/**
 * A class to help show and hide advanced form content.
 *
 * @module     core_form/showadvanced
 * @copyright  2016 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_form/showadvanced",["jquery","core/log","core/str","core/notification"],(function($,Log,Strings,Notification){var SELECTORS_FIELDSETCONTAINSADVANCED="fieldset.containsadvancedelements",SELECTORS_DIVFITEMADVANCED="div.fitem.advanced",SELECTORS_DIVADVANCEDSECTION="div#form-advanced-div",SELECTORS_MORELESSLINK="fieldset.containsadvancedelements .moreless-toggler",CSS_SHOW="show",CSS_MORELESSACTIONS="moreless-actions",CSS_MORELESSTOGGLER="moreless-toggler",CSS_SHOWLESS="moreless-less",WRAPPERS_FITEM='<div class="fitem"></div>',WRAPPERS_FELEMENT='<div class="felement"></div>',WRAPPERS_ADVANCEDDIV='<div id="form-advanced-div"></div>',uniqIdSeed=0,ShowAdvanced=function(id){this.id=id;var form=$(document.getElementById(id));this.enhanceForm(form)};return ShowAdvanced.prototype.id="",ShowAdvanced.prototype.enhanceForm=function(form){return form.find(SELECTORS_FIELDSETCONTAINSADVANCED).each(function(index,item){this.enhanceFieldset($(item))}.bind(this)),form.on("click",SELECTORS_MORELESSLINK,this.switchState),form.on("keydown",SELECTORS_MORELESSLINK,function(e){return 13!=e.which&&32!=e.which||this.switchState(e)}.bind(this)),this},ShowAdvanced.prototype.generateId=function(node){var id=node.prop("id");return void 0===id&&(id="showadvancedid-"+uniqIdSeed++,node.prop("id",id)),id},ShowAdvanced.prototype.enhanceFieldset=function(fieldset){var statuselement=$("input[name=mform_showmore_"+fieldset.prop("id")+"]");return statuselement.length?(Strings.get_strings([{key:"showmore",component:"core_form"},{key:"showless",component:"core_form"}]).then(function(results){var showmore=results[0],showless=results[1],morelesslink=$('<a href="#"></a>');morelesslink.addClass(CSS_MORELESSTOGGLER),"0"===statuselement.val()?(morelesslink.html(showmore),morelesslink.attr("aria-expanded","false")):(morelesslink.html(showless),morelesslink.attr("aria-expanded","true"),morelesslink.addClass(CSS_SHOWLESS),fieldset.find(SELECTORS_DIVFITEMADVANCED).addClass(CSS_SHOW));var idlist=[];fieldset.find(SELECTORS_DIVFITEMADVANCED).each(function(index,node){idlist[idlist.length]=this.generateId($(node))}.bind(this)),morelesslink.attr("role","button"),morelesslink.attr("aria-controls","form-advanced-div");var formadvancedsection=$(WRAPPERS_ADVANCEDDIV);fieldset.find(SELECTORS_DIVFITEMADVANCED).wrapAll(formadvancedsection);var fitem=$(WRAPPERS_FITEM);fitem.addClass(CSS_MORELESSACTIONS);var felement=$(WRAPPERS_FELEMENT);return felement.append(morelesslink),fitem.append(felement),fieldset.find(SELECTORS_DIVADVANCEDSECTION).before(fitem),!0}.bind(this)).fail(Notification.exception),this):(Log.debug("M.form.showadvanced::processFieldset was called on an fieldset without a status field: '"+fieldset.prop("id")+"'"),this)},ShowAdvanced.prototype.switchState=function(e){return e.preventDefault(),Strings.get_strings([{key:"showmore",component:"core_form"},{key:"showless",component:"core_form"}]).then((function(results){var showmore=results[0],showless=results[1],fieldset=$(e.target).closest(SELECTORS_FIELDSETCONTAINSADVANCED);fieldset.find(SELECTORS_DIVFITEMADVANCED).toggleClass(CSS_SHOW);var statuselement=$("input[name=mform_showmore_"+fieldset.prop("id")+"]");return"0"===statuselement.val()?(statuselement.val(1),$(e.target).addClass(CSS_SHOWLESS),$(e.target).html(showless),$(e.target).attr("aria-expanded","true")):(statuselement.val(0),$(e.target).removeClass(CSS_SHOWLESS),$(e.target).html(showmore),$(e.target).attr("aria-expanded","false")),!0})).fail(Notification.exception),this},{init:function(formid){return new ShowAdvanced(formid)}}}));

//# sourceMappingURL=showadvanced.min.js.map