/**
 * Factory to create a paged content widget.
 *
 * @module     core/paged_content_factory
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/paged_content_factory",["jquery","core/templates","core/notification","core/paged_content","core/paged_content_events","core/pubsub","core_user/repository"],(function($,Templates,Notification,PagedContent,PagedContentEvents,PubSub,UserRepository){var TEMPLATES_PAGED_CONTENT="core/paged_content",DEFAULT_ITEMS_PER_PAGE_SINGLE=25,DEFAULT_ITEMS_PER_PAGE_ARRAY=[25,50,100,0],DEFAULT_MAX_PAGES=3,buildItemsPerPagePagingBarContext=function(itemsPerPage){var context=[];$.isArray(itemsPerPage)?(context=itemsPerPage.map((function(num){return"number"==typeof num?{value:num,active:!1}:num}))).filter((function(item){return item.active})).length||(context[0].active=!0):context=[{value:itemsPerPage,active:!0}];return context},buildPagingBarTemplateContext=function(numberOfItems,itemsPerPage){return numberOfItems?function(numberOfItems,itemsPerPage){null===itemsPerPage&&(itemsPerPage=DEFAULT_ITEMS_PER_PAGE_SINGLE),$.isArray(itemsPerPage)&&(itemsPerPage=itemsPerPage[0]);var context={showitemsperpageselector:!1,itemsperpage:[{value:35,active:!0}],previous:!0,next:!0,activepagenumber:1,hidecontrolonsinglepage:!0,pages:[]};context.itemsperpage=buildItemsPerPagePagingBarContext(itemsPerPage);for(var numberOfPages=function(numberOfItems,itemsPerPage){var numberOfPages=1;if(numberOfItems>0){var partial=numberOfItems%itemsPerPage;numberOfPages=partial?(numberOfItems-=partial)/itemsPerPage+1:numberOfItems/itemsPerPage}return numberOfPages}(numberOfItems,itemsPerPage),i=1;i<=numberOfPages;i++){var page={number:i,page:""+i};1===i&&(page.active=!0),context.pages.push(page)}return context.barsize=10,context}(numberOfItems,itemsPerPage):function(itemsPerPage){null===itemsPerPage&&(itemsPerPage=DEFAULT_ITEMS_PER_PAGE_ARRAY);var context={showitemsperpageselector:!1,itemsperpage:[{value:35,active:!0}],previous:!0,next:!0,activepagenumber:1,hidecontrolonsinglepage:!0,pages:[]};return context.itemsperpage=buildItemsPerPagePagingBarContext(itemsPerPage),context.showitemsperpageselector=$.isArray(itemsPerPage)&&itemsPerPage.length>1,context}(itemsPerPage)},buildTemplateContext=function(numberOfItems,itemsPerPage,config){var context={pagingbar:!1,pagingdropdown:!1,skipjs:!0,ignorecontrolwhileloading:!0,controlplacementbottom:!1};return config.hasOwnProperty("ignoreControlWhileLoading")&&(context.ignorecontrolwhileloading=config.ignoreControlWhileLoading),config.hasOwnProperty("controlPlacementBottom")&&(context.controlplacementbottom=config.controlPlacementBottom),config.hasOwnProperty("hideControlOnSinglePage")&&(context.hidecontrolonsinglepage=config.hideControlOnSinglePage),config.hasOwnProperty("ariaLabels")&&(context.arialabels=config.ariaLabels),config.hasOwnProperty("dropdown")&&config.dropdown?context.pagingdropdown=function(itemsPerPage,config){if(null===itemsPerPage&&(itemsPerPage=DEFAULT_ITEMS_PER_PAGE_SINGLE),$.isArray(itemsPerPage))return{options:itemsPerPage};var context={options:[]},totalItems=0,lastIncrease=0,maxPages=DEFAULT_MAX_PAGES;config.hasOwnProperty("maxPages")&&(maxPages=config.maxPages);for(var i=1;i<=maxPages;i++){var itemCount=0;i<=2?(itemCount=itemsPerPage,lastIncrease=itemsPerPage):itemCount=lastIncrease*=2;var option={itemcount:itemCount,content:totalItems+=itemCount};1===i&&(option.active=!0),context.options.push(option)}return context}(itemsPerPage,config):(context.pagingbar=buildPagingBarTemplateContext(numberOfItems,itemsPerPage),config.hasOwnProperty("showFirstLast")&&config.showFirstLast&&(context.pagingbar.first=!0,context.pagingbar.last=!0)),context},createWithTotalAndLimit=function(numberOfItems,itemsPerPage,renderPagesContentCallback,config){config=config||{};var deferred=$.Deferred(),templateContext=buildTemplateContext(numberOfItems,itemsPerPage,config);return Templates.render(TEMPLATES_PAGED_CONTENT,templateContext).then((function(html,js){var id=(html=$(html)).attr("id");config.hasOwnProperty("eventNamespace")&&(id=config.eventNamespace);var container=html;PagedContent.init(container,renderPagesContentCallback,id),registerEvents(id,config),deferred.resolve(html,js)})).fail((function(exception){deferred.reject(exception)})).fail(Notification.exception),deferred.promise()},registerEvents=function(namespace,config){var persistentLimitKey;config.hasOwnProperty("persistentLimitKey")&&PubSub.subscribe(namespace+PagedContentEvents.SET_ITEMS_PER_PAGE_LIMIT,(persistentLimitKey=config.persistentLimitKey,function(limit){UserRepository.setUserPreference(persistentLimitKey,limit)}))};return{create:function(renderPagesContentCallback,config){return createWithTotalAndLimit(null,null,renderPagesContentCallback,config)},createWithLimit:function(itemsPerPage,renderPagesContentCallback,config){return createWithTotalAndLimit(null,itemsPerPage,renderPagesContentCallback,config)},createWithTotalAndLimit:createWithTotalAndLimit,createFromStaticList:function(contentItems,itemsPerPage,renderContentCallback,config){void 0===config&&(config={});var numberOfItems=contentItems.length;return createWithTotalAndLimit(numberOfItems,itemsPerPage,(function(pagesData){var contentToRender=[];return pagesData.forEach((function(pageData){var begin=pageData.offset,end=pageData.limit?begin+pageData.limit:numberOfItems,items=contentItems.slice(begin,end);contentToRender.push(items)})),renderContentCallback(contentToRender)}),config)},createFromAjax:createWithTotalAndLimit,resetLastPageNumber:function(id,lastPageNumber){PubSub.publish(id+PagedContentEvents.ALL_ITEMS_LOADED,lastPageNumber)}}}));

//# sourceMappingURL=paged_content_factory.min.js.map